/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.ritual;

import com.hollingsworth.arsnouveau.api.ritual.AbstractRitual;
import com.hollingsworth.arsnouveau.api.ritual.IRitualCaster;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;

public class RitualCaster
implements IRitualCaster {
    List<String> ritualIDs = new ArrayList<String>();
    String selectedRitualID = "";
    public ItemStack stack;

    private RitualCaster(ItemStack stack) {
        this.stack = stack;
    }

    @Override
    public List<String> getUnlockedRitualIDs() {
        return this.ritualIDs;
    }

    @Override
    public void unlockRitual(String ritualID) {
        if (!this.ritualIDs.contains(ritualID)) {
            this.ritualIDs.add(ritualID);
        }
        this.write(this.stack);
    }

    @Override
    public String getSelectedRitual() {
        return this.stack.m_41784_().m_128461_("selected");
    }

    @Override
    public void setRitual(AbstractRitual ritual) {
        this.setRitual(ritual.getID());
    }

    @Override
    public void setRitual(String ritualID) {
        this.selectedRitualID = ritualID;
        this.write(this.stack);
    }

    public static RitualCaster deserialize(ItemStack stack) {
        RitualCaster instance = new RitualCaster(stack);
        CompoundTag tag = stack.m_41784_();
        ArrayList<String> rituals = new ArrayList<String>();
        for (int i = 0; i < tag.m_128451_("numrituals"); ++i) {
            if (!tag.m_128441_("ritual_" + i)) continue;
            rituals.add(tag.m_128461_("ritual_" + i));
        }
        instance.ritualIDs = rituals;
        instance.selectedRitualID = tag.m_128461_("selected");
        return instance;
    }

    public void write(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128359_("selected", this.selectedRitualID);
        tag.m_128405_("numrituals", this.ritualIDs.size());
        for (int i = 0; i < this.ritualIDs.size(); ++i) {
            tag.m_128359_("ritual_" + i, this.ritualIDs.get(i));
        }
        stack.m_41751_(tag);
    }
}

